using System;
using System.Linq;

namespace takkvalifikacije
{
    static class Program
    {
        static void Main()
        {
            int[] input = Console.ReadLine().Split(' ').Select(v => int.Parse(v)).ToArray();
            int N = input[0];
            int K = input[1];

            if (K >= N - 1)
            {
                // Možemo izbaciti sve sem jednog elementa
                Console.WriteLine("One element");
                Console.WriteLine(0);
                return;
            }
            input = Console.ReadLine().Split(' ').Select(v => int.Parse(v)).ToArray();

            int[] count = new int[10];
            int min = -1, minCount = 0, max = -1;
            int minCountItem = -1, minCountItemCount = int.MaxValue;
            for (int i = 0; i < N; i++)
            {
                int item = input[i];
                count[item]++;
                if (min == -1 || item < min) { min = item; minCount = 1; }
                else minCount++;
                if (max == -1 || item > max) { max = item; }
            }
            for (int i = 0; i < 10; i++)
                if (count[i] < minCount)
                {
                    minCountItem = i;
                    minCountItemCount = count[i];
                }

            if (K < minCountItemCount)
            {
                // Ne možemo ništa uciniti
                Console.WriteLine("Dead end");
                Console.WriteLine(max * max - min * min);
                return;
            }
            if (K >= N - minCountItemCount)
            {
                // Možemo izbaciti sve sem dva ista elementa
                Console.WriteLine("Two same elements");
                Console.WriteLine(0);
                return;
            }

            int bestMax = -1, bestMin = -1, bestDiff = int.MaxValue;
            for (int i = 0; i < 10; i++)
                for (int j = i; j < 10; j++)
                {
                    if (i == j) continue;
                    if (count[i] == 0) break;
                    if (count[j] == 0) continue;
                    if (N - count[i] - count[j] > K)
                        // Nedovoljno operacija da se dostigne niz
                        continue;
                    if (j - i < bestDiff)
                    {
                        bestMin = i;
                        bestMax = j;
                        bestDiff = j - i;
                    }
                }
            if (bestDiff != int.MaxValue)
            {
                Console.WriteLine($"Two best elements {bestMax} - {bestMin}");
                Console.WriteLine(bestMax * bestMax - bestMin * bestMin);
            }
            else
            {
                Console.WriteLine("Dead end");
                Console.WriteLine(max * max - min * min);
            }
        }
    }
}